// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/service_port_service.mojom
//

package org.chromium.mojom.content;

class ServicePortService_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<ServicePortService, ServicePortService.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<ServicePortService, ServicePortService.Proxy>() {
    
        public String getName() {
            return "content::ServicePortService";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, ServicePortService impl) {
            return new Stub(core, impl);
        }
    
        public ServicePortService[] buildArray(int size) {
          return new ServicePortService[size];
        }
    };

    private static final int SET_CLIENT_ORDINAL = 0;
    private static final int CONNECT_ORDINAL = 1;
    private static final int POST_MESSAGE_ORDINAL = 2;
    private static final int CLOSE_PORT_ORDINAL = 3;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements ServicePortService.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void setClient(ServicePortServiceClient client) {
            ServicePortServiceSetClientParams _message = new ServicePortServiceSetClientParams();
            _message.client = client;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(SET_CLIENT_ORDINAL)));
        }

        @Override
        public void connect(String targetUrl, String origin, ConnectResponse callback) {
            ServicePortServiceConnectParams _message = new ServicePortServiceConnectParams();
            _message.targetUrl = targetUrl;
            _message.origin = origin;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServicePortServiceConnectResponseParamsForwardToCallback(callback));
        }

        @Override
        public void postMessage(int portId, String message, MojoTransferredMessagePort[] ports) {
            ServicePortServicePostMessageParams _message = new ServicePortServicePostMessageParams();
            _message.portId = portId;
            _message.message = message;
            _message.ports = ports;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(POST_MESSAGE_ORDINAL)));
        }

        @Override
        public void closePort(int portId) {
            ServicePortServiceClosePortParams _message = new ServicePortServiceClosePortParams();
            _message.portId = portId;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CLOSE_PORT_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<ServicePortService> {

        Stub(org.chromium.mojo.system.Core core, ServicePortService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ServicePortService_Internal.MANAGER, messageWithHeader);
                    case SET_CLIENT_ORDINAL: {
                        ServicePortServiceSetClientParams data =
                                ServicePortServiceSetClientParams.deserialize(messageWithHeader.getPayload());
                        getImpl().setClient(data.client);
                        return true;
                    }
                    case POST_MESSAGE_ORDINAL: {
                        ServicePortServicePostMessageParams data =
                                ServicePortServicePostMessageParams.deserialize(messageWithHeader.getPayload());
                        getImpl().postMessage(data.portId, data.message, data.ports);
                        return true;
                    }
                    case CLOSE_PORT_ORDINAL: {
                        ServicePortServiceClosePortParams data =
                                ServicePortServiceClosePortParams.deserialize(messageWithHeader.getPayload());
                        getImpl().closePort(data.portId);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ServicePortService_Internal.MANAGER, messageWithHeader, receiver);
                    case CONNECT_ORDINAL: {
                        ServicePortServiceConnectParams data =
                                ServicePortServiceConnectParams.deserialize(messageWithHeader.getPayload());
                        getImpl().connect(data.targetUrl, data.origin, new ServicePortServiceConnectResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class ServicePortServiceSetClientParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public ServicePortServiceClient client;
    
        private ServicePortServiceSetClientParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ServicePortServiceSetClientParams() {
            this(0);
        }
    
        public static ServicePortServiceSetClientParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ServicePortServiceSetClientParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServicePortServiceSetClientParams result = new ServicePortServiceSetClientParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.client = decoder0.readServiceInterface(8, false, ServicePortServiceClient.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(client, 8, false, ServicePortServiceClient.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ServicePortServiceSetClientParams other = (ServicePortServiceSetClientParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.client, other.client))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(client);
            return result;
        }
    }

    static final class ServicePortServiceConnectParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String targetUrl;
        public String origin;
    
        private ServicePortServiceConnectParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ServicePortServiceConnectParams() {
            this(0);
        }
    
        public static ServicePortServiceConnectParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ServicePortServiceConnectParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServicePortServiceConnectParams result = new ServicePortServiceConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.targetUrl = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(targetUrl, 8, false);
            encoder0.encode(origin, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ServicePortServiceConnectParams other = (ServicePortServiceConnectParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.targetUrl, other.targetUrl))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(targetUrl);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            return result;
        }
    }

    static final class ServicePortServiceConnectResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int result;
        public int portId;
    
        private ServicePortServiceConnectResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ServicePortServiceConnectResponseParams() {
            this(0);
        }
    
        public static ServicePortServiceConnectResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ServicePortServiceConnectResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServicePortServiceConnectResponseParams result = new ServicePortServiceConnectResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.result = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.portId = decoder0.readInt(12);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8);
            encoder0.encode(portId, 12);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ServicePortServiceConnectResponseParams other = (ServicePortServiceConnectResponseParams) object;
            if (this.result != other.result)
                return false;
            if (this.portId != other.portId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(portId);
            return result;
        }
    }

    static class ServicePortServiceConnectResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final ServicePortService.ConnectResponse mCallback;

        ServicePortServiceConnectResponseParamsForwardToCallback(ServicePortService.ConnectResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CONNECT_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                ServicePortServiceConnectResponseParams response = ServicePortServiceConnectResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result, response.portId);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServicePortServiceConnectResponseParamsProxyToResponder implements ServicePortService.ConnectResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServicePortServiceConnectResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, Integer portId) {
            ServicePortServiceConnectResponseParams _response = new ServicePortServiceConnectResponseParams();
            _response.result = result;
            _response.portId = portId;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class ServicePortServicePostMessageParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int portId;
        public String message;
        public MojoTransferredMessagePort[] ports;
    
        private ServicePortServicePostMessageParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ServicePortServicePostMessageParams() {
            this(0);
        }
    
        public static ServicePortServicePostMessageParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ServicePortServicePostMessageParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServicePortServicePostMessageParams result = new ServicePortServicePostMessageParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.portId = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.message = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.ports = new MojoTransferredMessagePort[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.ports[i1] = MojoTransferredMessagePort.decode(decoder2);
                    }
                }
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(portId, 8);
            encoder0.encode(message, 16, false);
            if (ports == null) {
                encoder0.encodeNullPointer(24, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(ports.length, 24, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < ports.length; ++i0) {
                    encoder1.encode(ports[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ServicePortServicePostMessageParams other = (ServicePortServicePostMessageParams) object;
            if (this.portId != other.portId)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.message, other.message))
                return false;
            if (!java.util.Arrays.deepEquals(this.ports, other.ports))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(portId);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(message);
            result = prime * result + java.util.Arrays.deepHashCode(ports);
            return result;
        }
    }

    static final class ServicePortServiceClosePortParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int portId;
    
        private ServicePortServiceClosePortParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ServicePortServiceClosePortParams() {
            this(0);
        }
    
        public static ServicePortServiceClosePortParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ServicePortServiceClosePortParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServicePortServiceClosePortParams result = new ServicePortServiceClosePortParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.portId = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(portId, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ServicePortServiceClosePortParams other = (ServicePortServiceClosePortParams) object;
            if (this.portId != other.portId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(portId);
            return result;
        }
    }

}

